angular.module('IDRMAGISOFT').controller('InitController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', '$interval', '$http'];
function InitController($scope, $state, $sessionStorage, servicios, $interval, $http) {
    
    delete $sessionStorage.IdServicio;
    delete $sessionStorage.Prioridad;
    delete $sessionStorage.idrelacionServicio;

    $scope.Turnos = [];
    $scope.turnosTotal = [];
    $scope.TurnosDetalle = [];
    $scope.MostrarPaginaInicio = true;
    $scope.MostrarTerminos = false;
    $sessionStorage.NombreCliente = '';
    $sessionStorage.Cedula = '';
    $sessionStorage.IdPersona = '';
    $sessionStorage.nivel = '';
    $sessionStorage.MostrarEntrega = '0';
    $sessionStorage.IdEntrega = '';
    $sessionStorage.tipoSeleccionada = '0';
    $sessionStorage.Telefono = '';
    $sessionStorage.Ubicacion = '';

    $scope.paginaInicio = function () {
        $http.get("app/model/Servidor.php?accion=PermisoTerminos")
        .then(function (response) {
            if(response.data.respuesta[0] == '0' || response.data.respuesta[0] == 0){
                $scope.ValidarSelecTipTurn();
            }else{
                $scope.MostrarPaginaInicio = false;
                $scope.MostrarTerminos = true;
            }
        });
    }
    $scope.openTurnos = function () {
        $scope.Turnos = [];
        $scope.turnosTotal = [];
        $http.get("app/model/Servidor.php?accion=getTurnos")
        .then(function (response) {
            $("#turnos ").modal("show");
            let keys = Object.keys(response.data);
            for (let index = 0; index < keys.length; index++) {
                const element = response.data[index];
                $scope.Turnos.push(element);
            }
            $scope.turnosTotal = $scope.Turnos;
        });
    }
    $scope.Ver = function (turno) {
        $scope.TurnosDetalle = [];
        $http.get("app/model/Servidor.php?accion=getTurnosAuditorias&Turno="+turno)
        .then(function (response) {
            
        $("#turnosDetalles").modal("show");
            let keys = Object.keys(response.data);
            for (let index = 0; index < keys.length; index++) {
                const element = response.data[index];
                $scope.TurnosDetalle.push(element);
            }
        });
    }
    $scope.changeQ = function (q) {
        if(q != ''){
            let t = $scope.Turnos;
            $scope.Turnos = t.filter((e)=>{
                if(e.Turno.toLowerCase().indexOf(q.toLowerCase()) != -1 || e.Nombre.toLowerCase().indexOf(q.toLowerCase()) != -1 || e.Cedula.toLowerCase().indexOf(q.toLowerCase()) != -1){
                    return e;
                }
            })
        }else{
            $scope.Turnos = $scope.turnosTotal;
        }
    }
    $scope.closeDetalle = function () {
        $("#turnosDetalles").modal("hide");
        $scope.Turnos = [];
        $scope.turnosTotal = [];
        $http.get("app/model/Servidor.php?accion=getTurnos")
        .then(function (response) {
            let keys = Object.keys(response.data);
            for (let index = 0; index < keys.length; index++) {
                const element = response.data[index];
                $scope.Turnos.push(element);
            }
            $scope.turnosTotal = $scope.Turnos;
        });
    }
    $scope.Cancelar = function (turno) {
        $http.get("app/model/Servidor.php?accion=Cancelar&turno="+turno)
        .then(function (response) {
             $scope.Turnos = [];
            $scope.turnosTotal = [];
            $http.get("app/model/Servidor.php?accion=getTurnos")
            .then(function (response) {
                let keys = Object.keys(response.data);
                for (let index = 0; index < keys.length; index++) {
                    const element = response.data[index];
                    $scope.Turnos.push(element);
                }
                $scope.turnosTotal = $scope.Turnos;
            });
        });
    }
    $scope.CancelarDetalle = function (IdAuditoria,turno) {
        $http.get("app/model/Servidor.php?accion=CancelarDetalle&IdAuditoria="+IdAuditoria)
        .then(function (response) {
            $scope.TurnosDetalle = [];
        $http.get("app/model/Servidor.php?accion=getTurnosAuditorias&Turno="+turno)
        .then(function (response) {
            let keys = Object.keys(response.data);
            for (let index = 0; index < keys.length; index++) {
                const element = response.data[index];
                $scope.TurnosDetalle.push(element);
            }
        });
        });
    }
    $scope.closeDetalle = function () {
        $("#turnosDetalles").modal("hide");
        $scope.Turnos = [];
        $scope.turnosTotal = [];
        $http.get("app/model/Servidor.php?accion=getTurnos")
        .then(function (response) {
            let keys = Object.keys(response.data);
            for (let index = 0; index < keys.length; index++) {
                const element = response.data[index];
                $scope.Turnos.push(element);
            }
            $scope.turnosTotal = $scope.Turnos;
        });
    }
    $scope.close = function () {
        $("#turnos").modal("hide");
    }
    $scope.ValidarSelecTipTurn = function(){
        $http.get("app/model/Servidor.php?accion=ValidarSelecTipTurn")
        .then(function (response) {
            if(response.data.respuesta[0] == '0' || response.data.respuesta[0] == 0){
                $scope.ValidarIrOpciones();
            }else{
                $state.go("SelecTipTurn");
            }
        });
    }


    $scope.ValidarIrOpciones = function() {
        $http.get("app/model/Servidor.php?accion=ValidarTercerNivel")
            .then(function (response) {
                if(response.data.respuesta[0] == '0' || response.data.respuesta[0] == 0){
                    $scope.ValidarIrCedula();
                }else{
                    $state.go("Opciones");
                }
        });
    }

    $scope.ValidarIrCedula = function() {
        $http.get("app/model/Servidor.php?accion=PermisoCedula")
            .then(function (response) {
                if(response.data.respuesta[0] == '0' || response.data.respuesta[0] == 0){
                    $state.go("Sercivios");
                }else{
                    $state.go("Cedula");
                }
            });
    }
    
    $scope.CargaInicial = function() {
        $http.get("app/model/Servidor.php?accion=CargaInicial")
            .then(function (response) {
               
            });
    }

    $scope.CargaInicial();
}