<?php

require __DIR__ . '\autoload.php';

use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;

/**
 * Install the printer using USB printing support, and the "Generic / Text Only" driver,
 * then share it (you can use a firewall so that it can only be seen locally).
 *
 * Use a WindowsPrintConnector with the share name to print.
 *
 * Troubleshooting: Fire up a command prompt, and ensure that (if your printer is shared as
 * "Receipt Printer), the following commands work:
 *
 *  echo "Hello World" > testfile
 *  copy testfile "\\%COMPUTERNAME%\Receipt Printer"
 *  del testfile
 */
try {
    // Enter the share name for your USB printer here
//    $connector = null;
    $nombre_Impresora = "ImpresoraTer";

    $connector = new WindowsPrintConnector($nombre_Impresora);

    /* Print a "Hello world" receipt" */
    $printer = new Printer($connector);

    $printer->setFont(Printer::FONT_C);
    $printer->setJustification(Printer::JUSTIFY_CENTER);
    $img = EscposImage::load("logo.png");
    $printer->graphics($img);
    $printer->setTextSize(2, 1);
    $printer->text(" TURNO\n");
//    $printer->setJustification(Printer:: JUSTIFY_CENTER);
    $printer->setTextSize(3, 3);
    $printer->text(" ASO-001\n");
    //$printer->setJustification(Printer::JUSTIFY_CENTER);
    $printer->setTextSize(2, 1);
    $printer->text(" SERVICIO: ASOCIACIONES\n");
    //$printer->setJustification(Printer::JUSTIFY_CENTER);
    $printer->setTextSize(1, 1);
    $printer->text(" ".date("Y-m-d H:i:s") . "\n");

    $printer->text(" www.ingetronik.com");
    $printer->feed();
    $img = EscposImage::load("ing.png");
    $printer->graphics($img);
    $printer->setJustification(Printer::JUSTIFY_CENTER);
    $printer->cut();
    $printer->pulse();

    /* Close printer */
    $printer->close();
} catch (Exception $e) {
    echo "Couldn't print to this printer: " . $e->getMessage() . "\n";
}
?>