import _objectSpread from "@babel/runtime/helpers/builtin/objectSpread";
import * as ns from 'react-jss/lib/ns';
import { SheetsRegistry } from 'jss';
import createShallow from './createShallow';
import { sheetsManager } from '../styles/withStyles';
const shallow = createShallow(); // Helper function to extract the classes from a styleSheet.

export default function getClasses(element, options = {}) {
  const sheetsRegistry = new SheetsRegistry();
  sheetsManager.clear();
  shallow(element, _objectSpread({}, options, {
    context: _objectSpread({
      [ns.sheetsRegistry]: sheetsRegistry
    }, options.context)
  }));
  return sheetsRegistry.registry[0].classes;
}