<?php

namespace App\Http\Controllers;

use App\Models\Gcategorias;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreGcategoriasRequest;
use App\Http\Requests\UpdateGcategoriasRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;

class GcategoriasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($request): JsonResponse
    {
        if($request == 'all'){
            $categorias = Gcategorias::all();
        }else{
            $categorias = Gcategorias::where('sede_id', $request)->get();
        }
        return response()->json($categorias, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreGcategoriasRequest $request): JsonResponse
    {
        try {
            $categoria = new Gcategorias();
            $categoria->fill($request->all());
            $categoria->saveOrFail();
            return response()->json(['message' => 'Categoria agregado exitosamente', 'product' => $categoria], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Gcategorias $gcategoria): JsonResponse
    {
        return response()->json($gcategoria, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Gcategorias $gcategorias)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateGcategoriasRequest $request, Gcategorias $gcategoria)
    {
        $gcategoria->fill($request->all());
        if ($gcategoria->save()) {
            return response()->json(['data' => $gcategoria, 'message' => 'La categoria se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $gcategoria, 'message' => 'Ha ocurrido un error al actualizar la categoria'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Gcategorias $gcategoria)
    {
        $gcategoria->delete();
        return response()->json(['data' => $gcategoria, 'message' => 'La categoria se ha eliminado correctamente'], 200);
    }
}
