<?php

namespace App\Http\Controllers;

use App\Models\tmantenimientos;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoretmantenimientosRequest;
use App\Http\Requests\UpdatetmantenimientosRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class TmantenimientosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $tmantenimientos = tmantenimientos::all();
        return response()->json($tmantenimientos, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoretmantenimientosRequest $request)
    {
        try {
            $tmantenimiento = new tmantenimientos();
            $tmantenimiento->fill($request->all());
            $tmantenimiento->saveOrFail();
            return response()->json(['message' => 'Tipo de mantenimiento agregado exitosamente', 'data' => $tmantenimiento], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(tmantenimientos $tmantenimiento)
    {
        return response()->json($tmantenimiento, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(tmantenimientos $tmantenimientos)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatetmantenimientosRequest $request, tmantenimientos $tmantenimiento)
    {
        $tmantenimiento->fill($request->all());
        if ($tmantenimiento->save()) {
            return response()->json(['data' => $tmantenimiento, 'message' => 'El tipo de mantenimiento se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $tmantenimiento, 'message' => 'Ha ocurrido un error al actualizar el tipo de mantenimiento'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(tmantenimientos $tmantenimiento)
    {
        $tmantenimiento->delete();
        return response()->json(['data' => $tmantenimiento, 'message' => 'El tipo de mantenimiento se ha eliminado correctamente'], 200);
    }
}
