<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class Cronogramas extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'instalacion',
        'calibracion',
        'frecuencia',
        'serie',
        'responsable',
        'inventario_id'
    ];

    public function inventario(): BelongsTo
    {
        return $this->belongsTo(inventario::class, 'inventario_id');
    }
    public function mantenimientos(): HasMany
    {
        return $this->HasMany(mantenimientos::class, 'cronograma_id','id');
    }
}
