<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class Gcategorias extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'nombre',
        'color',
        'general',
        'sede_id'
    ];

    public function gsede()
    {
        return $this->belongsTo(Gsedes::class, 'sede_id');
    }
    public function sedes()
    {
        return $this->belongsTo(Gsedes::class, 'sede_id');
    }

    public function gsubcategorias()
    {
        return $this->hasMany(Gsubcategorias::class, 'categoria_id');
    }
}
