<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class Gsedes extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'nombre',
    ];

    public function sede(): HasMany{
        return $this->HasMany(Ginventarios::class,'id','sede_id');
    }
    public function gcategorias()
    {
        return $this->hasMany(Gcategorias::class, 'sede_id');
    }
}
