<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class mantenimientos extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'mes',
        'year',
        'tipo',
        'cronograma_id',
    ];

    public function cronograma(): BelongsTo
    {
        return $this->belongsTo(Cronogramas::class, 'cronograma_id');
    }

}
